@echo off
setlocal

REM Kindle Key Finder V2 Launcher

REM Prevent Python from generating __pycache__ folders
set PYTHONDONTWRITEBYTECODE=1

REM Change to batch file's directory
cd /d "%~dp0"

REM Check for Python
where python >nul 2>&1
if errorlevel 1 (
    echo [ERROR] Python not found in PATH.
    pause
    goto :eof
)

REM Check for script
set "SCRIPT_PATH=%~dp0key_finder.py"
if not exist "%SCRIPT_PATH%" (
    echo [ERROR] Script not found: "%SCRIPT_PATH%"
    pause
    goto :eof
)

REM Create temporary wrapper script to avoid quote nesting issues
set "WRAPPER=%TEMP%\keyfinder_wrapper.bat"
(
    echo @echo off
    echo cd /d "%~dp0"
    echo python "%SCRIPT_PATH%"
) > "%WRAPPER%"

REM Launch wrapper in maximized window
start "Kindle Key Finder" /NORMAL cmd /k "call "%WRAPPER%" & del /f /q "%WRAPPER%" 2>nul"
