# Kindle Key Finder V2 - Launcher Options

This document explains the launcher options available to handle the cmd.exe 0xc0000142 error.

## The Problem

Sometimes Windows cmd.exe throws error 0xc0000142 (Application Error) when launching batch files. Testing has confirmed that **running with administrator privileges solves this problem completely**.

## Launchers Available

### 1. **run_keyfinder.bat** (Normal Mode)
- Standard launcher without admin privileges
- May occasionally encounter the 0xc0000142 error
- **Keeps window open** so you can see results and credits
- Use this if you don't want UAC prompts

**How to use:**
- Double-click `run_keyfinder.bat`
- If you get an error, try the admin launcher instead

### 2. **run_keyfinder_admin.vbs** (RECOMMENDED - Admin Mode)
- Launches with administrator privileges
- **Prevents the 0xc0000142 error completely**
- **Keeps window open** so you can see results and credits
- Shows UAC prompt for security
- Tested and proven to work reliably

**How to use:**
- Double-click `run_keyfinder_admin.vbs`
- Click "Yes" on the UAC prompt
- The application will launch with admin privileges

### Can I Double-Click key_finder.py Directly?

**Short answer: Not recommended.**

Double-clicking `key_finder.py` directly may work to START the script, but:
- ❌ The window may close immediately when finished (you won't see credits/results)
- ❌ If there's an error, the window closes before you can read it
- ❌ Depends on your Python file association settings
- ❌ May still encounter the 0xc0000142 error

The batch/VBS launchers are better because they:
- ✅ Keep the window open (`cmd /k`) so you can read everything
- ✅ Handle errors gracefully
- ✅ Work consistently regardless of file associations
- ✅ (Admin launcher) Prevent the 0xc0000142 error

**If you really want to run it manually from command line:**
```cmd
python key_finder.py
```
Then the window will stay open until you close it. But using the launchers is easier!

## Recommended Solution

**Use `run_keyfinder_admin.vbs`**

Based on extensive testing, running with admin privileges **prevents the 0xc0000142 error entirely**. This is the simplest and most reliable solution.

✅ Solves the 0xc0000142 error at the source
✅ No retries needed
✅ User-friendly UAC prompt
✅ Window stays open to view results

## Creating a Desktop Shortcut

To make launching easier:

1. Right-click on `run_keyfinder_admin.vbs`
2. Select "Create shortcut"
3. Move the shortcut to your Desktop
4. (Optional) Rename it to "Kindle Key Finder V2"
5. (Optional) Right-click > Properties > Change Icon to customize

## Troubleshooting

### Permission Error During Execution

**MOST COMMON CAUSE**: Calibre is running in the background!

The script now automatically detects if Calibre is running and warns you before proceeding. This helps prevent permission errors when trying to backup `dedrm.json`.

**If you get permission errors:**
1. Close Calibre completely
2. Open Task Manager (Ctrl+Shift+Esc)
3. Look for any `calibre.exe` or `calibre-*.exe` processes
4. End all Calibre-related processes
5. Run the script again

### UAC Prompt Doesn't Appear
- Make sure UAC is enabled in Windows settings
- Try right-clicking the .vbs file and selecting "Run as administrator"

### Error: "Python not found in PATH"
- Python is not installed or not in system PATH
- Install Python from python.org
- Make sure to check "Add Python to PATH" during installation

### Optional: Install psutil for Better Calibre Detection
The script uses an optional Python library called `psutil` for more reliable Calibre process detection. To install it:
```
pip install psutil
```
If `psutil` is not installed, the script will automatically fall back to using Windows `tasklist` command, which also works fine.

### Still Having Issues?
Try these steps:
- Restart your computer
- Run Windows Update
- Run `sfc /scannow` in admin CMD to check system files
- Temporarily disable antivirus and test
- Check for .NET Framework issues

## Technical Details

### Why Admin Privileges Fix the 0xc0000142 Error
The 0xc0000142 error (Application failed to initialize properly) is often caused by permission issues or DLL conflicts. Running with admin privileges:
- Bypasses certain permission restrictions
- Allows proper initialization of system resources
- Prevents interference from security software

### Calibre Detection
The script automatically detects if Calibre is running before attempting to backup the `dedrm.json` file, preventing permission errors. It uses:
- `psutil` library (if installed) for reliable process detection
- Windows `tasklist` command as fallback

### VBScript Admin Elevation
The VBScript file uses `Shell.Application.ShellExecute` with the "runas" verb to request admin privileges through Windows UAC (User Account Control).
